package ibase.servlet;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

import java.text.SimpleDateFormat;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;

import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMessage.RecipientType;
import javax.mail.internet.MimeMultipart;
import javax.servlet.ServletException;
import javax.servlet.annotation.MultipartConfig;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;

import ibase.util.EmployeeDao;
import ibase.utility.BaseLogger;

@WebServlet("/email")
@MultipartConfig(fileSizeThreshold = 1024 * 1024 * 2, // 2MB
		maxFileSize = 1024 * 1024 * 10, // 10MB
		maxRequestSize = 1024 * 1024 * 50) // 50MB
public class SendMail extends HttpServlet {

	private static final long serialVersionUID = 1L;
	String empcode, requestid, description, actiondtl, stdtime, newStatus, newRemark;
	String hrsSpendToday, hrsLeft, dateEnd, startdate, newTaskSrno, additionalEmail;
	String attachment1, attachment2, attachment3;
	String currentStatus, email;
	String endDate;
	List<File> uploadedFiles;
	int timespend;
	String action;

	protected void doGet(HttpServletRequest request, HttpServletResponse response) {
		empcode = request.getParameter("empcode");
		requestid = request.getParameter("requestid");
		description = request.getParameter("description");
		actiondtl = request.getParameter("actiondtl");
		stdtime = request.getParameter("stdtime");
	}

	protected void doPost(HttpServletRequest request, HttpServletResponse response) {
		action = request.getParameter("action");
		response.setContentType("text/plain;charset=UTF-8");
		BaseLogger.log("0", null, null, "Got Action in SendMail..... " + action);
		if (action.equalsIgnoreCase("statusRequest")) {
			BaseLogger.log("0", null, null, "Got Action..... statusRequest");
			try {
				newRemark = request.getParameter("newRemark");
				stdtime = request.getParameter("stdtime");
				startdate = request.getParameter("startdate");
				endDate = getEndDate(Integer.parseInt(stdtime), startdate);
				currentStatus = request.getParameter("currentStatus");
				additionalEmail = request.getParameter("additionalEmail");
				requestid = request.getParameter("requestid");
				email = request.getParameter("additionalEmail");
				timespend = Integer.parseInt(request.getParameter("timespend"));
				description = request.getParameter("description");
				actiondtl = request.getParameter("actiondtl");

				BaseLogger.log("0", null, null, "SendMail.....newRemark=" + newRemark);
				BaseLogger.log("0", null, null, "SendMail.....stdtime=" + stdtime);
				BaseLogger.log("0", null, null, "SendMail.....startdate=" + startdate);
				BaseLogger.log("0", null, null, "SendMail.....endDate=" + endDate);
				BaseLogger.log("0", null, null, "SendMail.....currentStatus=" + currentStatus);
				BaseLogger.log("0", null, null, "SendMail.....additionalEmail=" + additionalEmail);
				BaseLogger.log("0", null, null, "SendMail.....email=" + email);
				BaseLogger.log("0", null, null, "SendMail.....timespend=" + timespend);
				BaseLogger.log("0", null, null, "SendMail.....description=" + description);
				BaseLogger.log("0", null, null, "SendMail.....actiondtl=" + actiondtl);

				int flag = sendStatusRequestEmail();
				if (flag == 1) {
					response.getWriter().write("Email Send Success");
				} else
					response.getWriter().write("Email Send faild");
			} catch (Exception e) {
				BaseLogger.log("0", null, null, "SendMail.....Error=" + e.getMessage());
				e.printStackTrace();
			}

		} else if (action.equalsIgnoreCase("statusUpdate")) {
			newStatus = request.getParameter("newStatus");
			newRemark = request.getParameter("newRemark");
			hrsSpendToday = request.getParameter("hrsSpendToday");
			hrsLeft = request.getParameter("hrsLeft");
			dateEnd = request.getParameter("dateEnd");
			startdate = request.getParameter("startdate");
			newTaskSrno = request.getParameter("newTaskSrno");
			additionalEmail = request.getParameter("additionalEmail");
			attachment1 = request.getParameter("attachment1");
			attachment2 = request.getParameter("attachment2");
			attachment3 = request.getParameter("attachment3");

			empcode = request.getParameter("empcode");
			requestid = request.getParameter("requestid");
			description = request.getParameter("description");
			actiondtl = request.getParameter("actiondtl");
			stdtime = request.getParameter("stdtime");
			timespend = Integer.parseInt(request.getParameter("timespend"));

			BaseLogger.log("0", null, null, "SendMail.....newStatus=" + newStatus);
			BaseLogger.log("0", null, null, "SendMail.....newRemark=" + newRemark);
			BaseLogger.log("0", null, null, "SendMail.....hrsSpendToday=" + hrsSpendToday);
			BaseLogger.log("0", null, null, "SendMail.....hrsLeft=" + hrsLeft);
			BaseLogger.log("0", null, null, "SendMail.....dateEnd=" + dateEnd);
			BaseLogger.log("0", null, null, "SendMail.....startdate=" + startdate);
			BaseLogger.log("0", null, null, "SendMail.....newTaskSrno=" + newTaskSrno);
			BaseLogger.log("0", null, null, "SendMail.....additionalEmail=" + additionalEmail);
			BaseLogger.log("0", null, null, "SendMail.....attachment1=" + attachment1);
			BaseLogger.log("0", null, null, "SendMail.....attachment2=" + attachment2);
			BaseLogger.log("0", null, null, "SendMail.....attachment3=" + attachment3);

			BaseLogger.log("0", null, null, "SendMail.....empcode=" + empcode);
			BaseLogger.log("0", null, null, "SendMail.....requestid=" + requestid);
			BaseLogger.log("0", null, null, "SendMail.....description=" + description);
			BaseLogger.log("0", null, null, "SendMail.....actiondtl=" + actiondtl);
			BaseLogger.log("0", null, null, "SendMail.....stdtime=" + stdtime);
			BaseLogger.log("0", null, null, "SendMail.....timespend=" + timespend);
			try {
				uploadedFiles = saveUploadedFiles(request);
				BaseLogger.log("0", null, null, "SendMail.....uploadFile="+uploadedFiles);

			} catch (IllegalStateException | IOException | ServletException e) {
				BaseLogger.log("0", null, null, "SendMail.....uploadFile Error=" + e.getMessage());
				e.printStackTrace();
			}

			endDate = getEndDate(Integer.parseInt(stdtime), startdate);
			BaseLogger.log("0", null, null, "SendMail.....endDate=" + endDate);
			int flag = generateEmail();
			BaseLogger.log("0", null, null, "SendMail.....flag=" + flag);
			response.setContentType("text/plain;charset=UTF-8");

			try {
				if (flag == 1) {
					response.getWriter().write("Email Send Success....");
				} else
					response.getWriter().write("Email Send Fail....");
			} catch (IOException e) {
				BaseLogger.log("0", null, null, "SendMail.....Error=" + e.getMessage());
				e.printStackTrace();
			}
		}
	}

	private int sendStatusRequestEmail() {
		try {
			BaseLogger.log("0", null, null, "Employee Email===" + email);

			String to = email + "1";
			BaseLogger.log("0", null, null, "updated " + to);

			String from = "ankush.supnar@proteustech.in";
			String host = "smtp.gmail.com";

			Properties properties = System.getProperties();
			properties.put("mail.smtp.host", host);
			properties.put("mail.smtp.port", "465");
			properties.put("mail.smtp.ssl.enable", "true");
			properties.put("mail.smtp.auth", "true");
			Session session = Session.getInstance(properties, new javax.mail.Authenticator() {
				protected PasswordAuthentication getPasswordAuthentication() {
					return new PasswordAuthentication("ankush.supnar@proteustech.in", "hanw nzfp gvgk sanq");
					// return new PasswordAuthentication("ankush.supnar@proteustech.in", "hgma stvh
					// aeyi wdhg");
				}
			});
			// session.setDebug(true);
			MimeMessage message = new MimeMessage(session);
			// set CC recipient
			message.addRecipient(RecipientType.CC, new InternetAddress("ankush.supnar@proteustech.in"));

			message.setFrom(new InternetAddress(from));

			message.addRecipient(Message.RecipientType.TO, new InternetAddress(to));

			message.setSubject("Request For Status " + requestid);
			BodyPart mailBody = new MimeBodyPart();
			MimeBodyPart htmlPart = new MimeBodyPart();

			Multipart multipart = new MimeMultipart();
			multipart.addBodyPart(htmlPart);
			mailBody.setHeader("ContentType", "text/html");

			String html = "ReqID: " + requestid + "<br/>" + "Request Descr:" + description + "<br/><br/>"
					+ "Planned End: " + getDateColor(endDate)
					+ " &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"
					+ "Effort Planned: " + stdtime
					+ " &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"
					+ "Time Spent:" + timespend
					+ " &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"
					+ "Status: " + currentStatus + "<br/><br/>" + "Comment:" + " <html><font color=blue>" + newRemark
					+ "</font></html>";
			BaseLogger.log("0", null, null, "SendMail.....sendStatusRequestEmail() html=" + html);
			htmlPart.setContent(html, "text/html; charset=utf-8");
			message.setContent(multipart);
			Transport.send(message);
			BaseLogger.log("0", null, null, "Sent mail successfully===>" + message);
			return 1;
		} catch (Exception e) {
			BaseLogger.log("0", null, null, "SendMail.....sendStatusRequestEmail() Error=" + e.getMessage());
			e.printStackTrace();
			return 0;
		}

	}

	String getEndDate(int stdtime, String startDate) {
		try {
			int time = (int) Math.ceil(stdtime / 9);
			SimpleDateFormat formate = new SimpleDateFormat("dd-MM-yyyy");

			Date dateStart = formate.parse(startdate);
			Calendar cal = Calendar.getInstance();
			cal.setTime(dateStart);
			// cal.add(Calendar.DATE, time);

			LocalDate start = LocalDateTime.ofInstant(cal.toInstant(), cal.getTimeZone().toZoneId()).toLocalDate();
			LocalDate end = start.plusDays(time);

			int i = 0;
			for (LocalDate date = start; date.isBefore(end); date = date.plusDays(1)) {
				DayOfWeek day = date.getDayOfWeek();
				if (day.getValue() == 6 || day.getValue() == 7) {
					i++;
				}
			}
			time += i;

			end = start.plusDays(time);
			DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd-MMM-YYYY");
			return formatter.format(end);
		} catch (Exception e) {
			e.printStackTrace();
			return "";
		}
	}

	public int generateEmail() {
		String email = new EmployeeDao().getEmployeeEmailid(empcode);
		BaseLogger.log("0", null, null, "Employee Email===" + email);

		BaseLogger.log("0", null, null, "email=" + email);
		String to = email + "1";
		BaseLogger.log("0", null, null, "updated " + to);

		String from = "ankush.supnar@proteustech.in";
		String host = "smtp.gmail.com";

		Properties properties = System.getProperties();

		properties.put("mail.smtp.host", host);
		properties.put("mail.smtp.port", "465");
		properties.put("mail.smtp.ssl.enable", "true");
		properties.put("mail.smtp.auth", "true");

		Session session = Session.getInstance(properties, new javax.mail.Authenticator() {

			protected PasswordAuthentication getPasswordAuthentication() {

				return new PasswordAuthentication("ankush.supnar@proteustech.in", "hanw nzfp gvgk sanq");
			}
		});
		// session.setDebug(true);

		try {

			MimeMessage message = new MimeMessage(session);
			// set CC recipient
			message.addRecipient(RecipientType.CC, new InternetAddress("ankush.supnar@proteustech.in"));

			message.setFrom(new InternetAddress(from));

			message.addRecipient(Message.RecipientType.TO, new InternetAddress(to));

			message.setSubject("Status update " + requestid);

			BodyPart mailBody = new MimeBodyPart();

			mailBody.setHeader("ContentType", "text/html");

			// String endDateValid = getColoredEndDate(endDate,dateEnd);

			String html = "Dear Sir/Madam," + "<br/>" + "I worked on following:" + "<br/><br/>" + "ReqID: " + requestid
					+ "<br/>" + "Planned End: " + endDate
					+ "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"
					+ "New End Date:" + getColoredEndDate(endDate, dateEnd) + "<br/><br/>" + "Effort planned: "
					+ stdtime
					+ " &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"
					+ getColoredTime(Integer.parseInt(stdtime), timespend, Integer.parseInt(hrsSpendToday),
							Integer.parseInt(hrsLeft))
					+ "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"
					+ "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"
					+ "Status:" + newStatus + "<br/><br/><br/>" + "Request Descr: " + description + "<br/><br/><br/>"
					+ "Action Details:" + actiondtl + "<br/><br/><br/>" + "New Remarks:" + newRemark;
			BaseLogger.log("0", null, null, "SendMail.....generateEmail() html=" + html);
			MimeBodyPart htmlPart = new MimeBodyPart();
			htmlPart.setContent(html, "text/html; charset=utf-8");

			Multipart multipart = new MimeMultipart();
			multipart.addBodyPart(htmlPart);

			if (uploadedFiles != null && uploadedFiles.size() > 0) {
				for (File file : uploadedFiles) {
					MimeBodyPart attachPart = new MimeBodyPart();
					try {
						attachPart.attachFile(file);
					} catch (IOException ex) {
						BaseLogger.log("0", null, null, "SendMail.....generateEmail() upload file error=" + ex);
						ex.printStackTrace();
					}
					multipart.addBodyPart(attachPart);
				}
			}
			message.setContent(multipart);
			BaseLogger.log("0", null, null, "sending...");
			Transport.send(message);
			BaseLogger.log("0", null, null, "Sent mail successfully...." + message);
			return 1;
		} catch (MessagingException mex) {
			BaseLogger.log("0", null, null, "SendMail.....generateEmail() send mail error=" + mex);
			mex.printStackTrace();
			return 0;
		}
	}

	String getColoredEndDate(String plandate, String dateNewEnd) {
		DateTimeFormatter formatter = DateTimeFormatter.ofPattern("d-MMM-yyyy");
		BaseLogger.log("0", null, null, plandate);
		LocalDate planDate = LocalDate.parse(plandate, formatter);
		LocalDate newDate = LocalDate.parse(dateNewEnd, formatter);

		if (planDate.compareTo(newDate) == -1) {

			return "<html><font color=red>" + dateNewEnd + "</font></html>";
		} else {

			return dateNewEnd;
		}
	}

	String getDateColor(String date) {
		try {
			DateTimeFormatter formatter = DateTimeFormatter.ofPattern("d-MMM-yyyy");
			LocalDate endDate = LocalDate.parse(date, formatter);
			BaseLogger.log("0", null, null, "compare end date to now date=" + endDate.compareTo(LocalDate.now()));
			if (endDate.compareTo(LocalDate.now()) == -1) {
				return "<html><font color=red>" + endDate + "</font></thml>";
			} else
				return date;
		} catch (Exception e) {
			e.printStackTrace();
			return "";
		}
	}

	String getColoredTime(int stdtime, int timespend, int hrsSpendToday, int hrsLeft) {
		int total = timespend + hrsSpendToday;
		if (total > stdtime) {
			return "Spent:<html><font color=red>" + hrsSpendToday + "(" + timespend + ")</font></html>"
					+ "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"
					+ "Required:<html><font color=red>" + hrsLeft + "</font></html>";
		}
		return "Spent:" + hrsSpendToday + "(" + timespend + ")"
				+ "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"
				+ "Required:" + hrsLeft;
	}

	public MimeBodyPart addBodyPart(String filename) {

		MimeBodyPart mailBody = new MimeBodyPart();
		DataSource source = new FileDataSource(filename);
		try {
			mailBody.setDataHandler(new DataHandler(source));
			mailBody.setFileName(filename);
		} catch (MessagingException e) {
			e.printStackTrace();
		}

		return mailBody;

	}

	public int sendEmail(String empcode, String requestid, String description) {
		String email = new EmployeeDao().getEmployeeEmailid(empcode);
		BaseLogger.log("0", null, null, "sendEmail() email" + email);
		String to = email + "1";
		BaseLogger.log("0", null, null, "updated " + to);

		String from = "ankush.supnar@proteustech.in";
		String host = "smtp.gmail.com";

		Properties properties = System.getProperties();

		properties.put("mail.smtp.host", host);
		properties.put("mail.smtp.port", "465");
		properties.put("mail.smtp.ssl.enable", "true");
		properties.put("mail.smtp.auth", "true");

		Session session = Session.getInstance(properties, new javax.mail.Authenticator() {

			protected PasswordAuthentication getPasswordAuthentication() {

				return new PasswordAuthentication("ankush.supnar@proteustech.in", "hanw nzfp gvgk sanq");
			}
		});
		// session.setDebug(true);

		try {

			MimeMessage message = new MimeMessage(session);
			// set CC recipient
			message.addRecipient(RecipientType.CC, new InternetAddress("ankush.supnar@proteustech.in"));

			message.setFrom(new InternetAddress(from));

			message.addRecipient(Message.RecipientType.TO, new InternetAddress(to));

			message.setSubject("Status update " + requestid);

			message.setText("Please update status of Request....." + description);

			BaseLogger.log("0", null, null, "sending...");

			Transport.send(message);
			BaseLogger.log("0", null, null, "Sent mail successfully...." + message);
			return 1;
		} catch (MessagingException mex) {
			mex.printStackTrace();
			return 0;
		}

	}

	void getAllParameters(HttpServletRequest req) {
		Enumeration<String> parameterNames = req.getParameterNames();
		while (parameterNames.hasMoreElements()) {

			String paramName = parameterNames.nextElement();
			String[] paramValues = req.getParameterValues(paramName);
			for (int i = 0; i < paramValues.length; i++) {
				String paramValue = paramValues[i];
				BaseLogger.log("0", null, null, paramName + "=" + paramValue);
			}
		}

	}

	private List<File> saveUploadedFiles(HttpServletRequest request)
			throws IllegalStateException, IOException, ServletException {
		List<File> listFiles = new ArrayList<File>();
		byte[] buffer = new byte[4096];
		int bytesRead = -1;
		Collection<Part> multiparts = request.getParts();
		BaseLogger.log("0", null, null, "saveFile: Multipart size= " + multiparts.size());
		if (multiparts.size() > 0) {
			for (Part part : request.getParts()) {

				String fileName = extractFileName(part);
				if (fileName == null || fileName.equals("")) {

					continue;
				}

				File saveFile = new File(fileName);
				BaseLogger.log("0", null, null, "saveFile: " + saveFile.getAbsolutePath());
				FileOutputStream outputStream = new FileOutputStream(saveFile);

				InputStream inputStream = part.getInputStream();
				while ((bytesRead = inputStream.read(buffer)) != -1) {
					outputStream.write(buffer, 0, bytesRead);
				}
				outputStream.close();
				inputStream.close();

				listFiles.add(saveFile);
			}
		}
		return listFiles;
	}

	private String extractFileName(Part part) {
		String contentDisp = part.getHeader("content-disposition");
		String[] items = contentDisp.split(";");
		for (String s : items) {
			if (s.trim().startsWith("filename")) {
				return s.substring(s.indexOf("=") + 2, s.length() - 1);
			}
		}
		return null;
	}

}